/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.util;

import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class BetterCavesUtils {
    public static Predicate<Biome.Category> isOcean = b -> b == Biome.Category.OCEAN;
    public static Predicate<Biome.Category> isNotOcean = b -> b != Biome.Category.OCEAN;

    private BetterCavesUtils() {
    }

    public static int getMaxSurfaceAltitudeSubChunk(IChunk chunkIn, int subX, int subZ) {
        int[] testCoords;
        int maxHeight = 0;
        for (int x : testCoords = new int[]{0, 1}) {
            for (int z : testCoords) {
                maxHeight = Math.max(maxHeight, BetterCavesUtils.getSurfaceAltitudeForColumn(chunkIn, subX * 2 + x, subZ * 2 + z));
            }
        }
        return maxHeight;
    }

    public static int getSurfaceAltitudeForColumn(IChunk chunkIn, int localX, int localZ) {
        return BetterCavesUtils.searchSurfaceAltitudeInRangeForColumn(chunkIn, localX, localZ, 255, 0);
    }

    public static int searchSurfaceAltitudeInRangeForColumn(IChunk chunkIn, int localX, int localZ, int topY, int bottomY) {
        BlockPos topPos;
        BlockPos.Mutable blockPos = new BlockPos.Mutable(localX, bottomY, localZ);
        if (topY == 255 && chunkIn.func_180495_p(topPos = new BlockPos(localX, topY, localZ)) != Blocks.field_150350_a.func_176223_P() && chunkIn.func_180495_p(topPos).func_185904_a() != Material.field_151586_h) {
            return 255;
        }
        for (int y = bottomY; y <= topY; ++y) {
            BlockState blockState = chunkIn.func_180495_p((BlockPos)blockPos);
            if (blockState == Blocks.field_150350_a.func_176223_P() || blockState.func_185904_a() == Material.field_151586_h) {
                return y;
            }
            blockPos.func_189536_c(Direction.UP);
        }
        return 1;
    }

    public static int getLocal(int coordinate) {
        return coordinate & 0xF;
    }

    public static boolean isPosInWorld(ColPos pos, IWorld world) {
        return world.func_217354_b(pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static boolean isPosInWorld(BlockPos pos, IWorld world) {
        return world.func_217354_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static float getDistFactor(IWorld worldIn, Map<Long, Biome> biomeMap, ColPos pos, int radius, Predicate<Biome.Category> isTargetBiome) {
        ColPos.Mutable checkpos = new ColPos.Mutable();
        for (int i = 1; i <= radius; ++i) {
            for (int j = 0; j <= i; ++j) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    checkpos.setPos(pos).move(direction, i).move(direction.func_176746_e(), j);
                    if (BetterCavesUtils.isPosInWorld((ColPos)checkpos, worldIn) && isTargetBiome.test(biomeMap.get(checkpos.toLong()).func_201856_r())) {
                        return (float)(i + j) / (float)(2 * radius);
                    }
                    if (j == 0 || i == j) continue;
                    checkpos.setPos(pos).move(direction, i).move(direction.func_176735_f(), j);
                    if (!BetterCavesUtils.isPosInWorld((ColPos)checkpos, worldIn) || !isTargetBiome.test(biomeMap.get(checkpos.toLong()).func_201856_r())) continue;
                    return (float)(i + j) / (float)(2 * radius);
                }
            }
        }
        return 1.0f;
    }

    public static float getDistFactor(IWorld worldIn, Function<BlockPos, Biome> biomePos, BlockPos pos, int radius, Predicate<Biome.Category> isTargetBiome) {
        BlockPos.Mutable checkpos = new BlockPos.Mutable();
        for (int i = 1; i <= radius; ++i) {
            for (int j = 0; j <= i; ++j) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    checkpos.func_189533_g((Vector3i)pos).func_189534_c(direction, i).func_189534_c(direction.func_176746_e(), j);
                    if (BetterCavesUtils.isPosInWorld((BlockPos)checkpos, worldIn) && isTargetBiome.test(biomePos.apply((BlockPos)checkpos).func_201856_r())) {
                        return (float)(i + j) / (float)(2 * radius);
                    }
                    if (j == 0 || i == j) continue;
                    checkpos.func_189533_g((Vector3i)pos).func_189534_c(direction, i).func_189534_c(direction.func_176735_f(), j);
                    if (!BetterCavesUtils.isPosInWorld((BlockPos)checkpos, worldIn) || !isTargetBiome.test(biomePos.apply((BlockPos)checkpos).func_201856_r())) continue;
                    return (float)(i + j) / (float)(2 * radius);
                }
            }
        }
        return 1.0f;
    }
}

